<?php

namespace App\Http\Controllers\Site\Exam;

use App\Models\Academic\AcademicExamType;
use App\Models\Examinations\Examination;
use App\Models\Site\Exam\SiteExamDeclares;
use App\Models\Site\Exam\SiteExamDeclareStudent;
use App\Models\Site\Exam\SiteExamDeclareStudentSubject;
use App\Models\Site\Exam\SiteExaminationExamTypeSetting;
use App\Models\Site\Exam\SiteExamRoutine;
use App\Models\Site\Exam\SiteSubjectExaminationExamTypeMark;
use App\Models\Site\Exam\SiteSubjectExaminationMark;
use App\Models\Site\Student\Student;
use App\Models\Student\StudentHistory;
use App\Models\SubjectGroupConditionSetting\SubjectGroupConditionSetting;
use DateTime;
use Exception;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Academic\AcademicClass;
use App\Models\Academic\AcademicShift;
use App\Models\AcademicYear\AcademicYear;
use App\Models\Site\Employee\Employee;
use App\Models\Site\SiteInfo;
use Carbon\Carbon;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\JsonResponse;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Response as FacadesResponse;
use Illuminate\Support\Facades\Session as FacadesSession;
use Illuminate\Support\Facades\View;
use JsonSchema\Exception\ValidationException;
use Response;
use Session;

class SiteBaseExamDeclareController extends Controller
{

    private $siteExamDeclares;
    public function __construct(SiteExamDeclares $siteExamDeclares)
    {
        $this->middleware('auth');
        $this->middleware('sitepagechecker');

        $this->siteExamDeclares = $siteExamDeclares;
    }

 

    public function index()
    {
        $viewType = 'Site Exam Committee Declare Page';

        return view('default.admin.layouts.master', compact('viewType'));
//        return view('default.admin.site.exam.site-base-exam-declare', compact('viewType'));

    }


    public function getExaminationListForExamDeclare(Request $requests){

        $data = $requests->all();

        $examination_ids=SiteExaminationExamTypeSetting::
            when(!empty($data['academic_year_id']), function ($query) use ($data) {
                return $query->where('academic_year_id', $data['academic_year_id']);
            })
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                return $query->where('academic_class_id', $data['academic_class_id']);
            })
            ->where('direct_result_input', false)
            ->pluck('examination_id')
            ->unique()
            ->filter();

        $examination=Examination::whereIn('id', $examination_ids)->get();


        return response()->json(['examination'=>$examination]);
    }

    public function getStudentListForExamDeclare(Request $requests)
    {
        try {

            ini_set('memory_limit', '-1');

            $data = $requests->all();

            $student_array = StudentHistory::select('id', 'user_id', 'student_roll_number')
                ->with(['student' => function ($query) {
                    $query->select('id');
                    $query->where('user_type', 'student');
                }])
                ->where('academic_version_id', $requests->academic_version_id)
                ->when(!empty($data['academic_year_id']), function ($query) use ($data) {
                    return $query->where('academic_year_id', $data['academic_year_id']);
                })
                ->when(!empty($data['academic_shift_id']), function ($query) use ($data) {
                    return $query->where('academic_shift_id', $data['academic_shift_id']);
                })
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_id']), function ($query) use ($data) {
                    return $query->where('academic_class_id', $data['academic_class_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', true)
                ->orderBy('student_roll_number', 'ASC')
                ->get();


            $student_arr=Array();
            $studentList=[];
            foreach ($student_array as $key => $value) {
                $student_arr['id']=$value->id;
                $student_arr['full_name']=$value->full_name;
                $student_arr['student_roll_number']=$value->student_roll_number;
                $student_arr['student_full_roll_number']=$value->student_full_roll_number;

                $studentList[$key]=$student_arr;
            }

           // dd($studentList);

            $subjects=SubjectGroupConditionSetting::select('id', 'academic_subject_id', 'academic_class_group_ids')
                ->with(['siteSubjectExaminationMark'=>function($q) use ($data){
                    $q->where('examination_id', $data['examination_id']);
                    $q->where('status', true);
                    $q->with(['siteSubjectExaminationExamTypeMark'=>function($que){
                        $que->with(['academicExamType']);
                        $que->where('status', true);
                }]);
                }, 'academicSubjectClassExamCondition'])
                ->whereHas('academicSubjectClassExamCondition', function ($q) {
                    $q->where('name_key', 'onlyforexam')
                        ->orWhere('name_key', 'forclassandexam')
                        ->orWhere('name_key', 'onlyresultshow');
                })
                ->where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->where('status', true)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->get();



            $subjects_array=[];
            foreach ($subjects as $key => $value) {
                if(count($value->academic_class_groups)>0 ){

                    $check_subject_group= $value->academic_class_groups
                        ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('id', $data['academic_class_group_id']);
                    })
                    ->first();

                    if($check_subject_group){
                        $subjects_array[]=$value;
                    }

                }else{
                    $subjects_array[]=$value;
                }

            }

            $examtypesetting=SiteExaminationExamTypeSetting::where('examination_id', $requests->examination_id)->get();


            $subject_list_array=[];
            $subject_list_arr=Array();
            foreach ($subjects_array as $key => $value) {

                $def_array=[];
                $def_arr=Array();
                foreach ($value->siteSubjectExaminationMark as $ke => $valu) {
                    $abc_arr=Array();
                    $abc_array=[];
                    foreach ($valu->siteSubjectExaminationExamTypeMark as $k => $val) {

                        foreach ($examtypesetting as $ks => $vals) {

                            if($vals->examination_id==$valu->examination_id && $vals->academic_exam_type_id==$val->academic_exam_type_id){

                                $abc_arr['exam_day']=$vals->exam_day;
                                $abc_arr['select_exam_type_id']=false;
                                $abc_arr['online_exam_status']=false;
                                $abc_arr['online_result_show_student']=false;
                                $abc_arr['student_per_day']=null;
                                $abc_arr['routine_id']=null;

                                $abc_array[$k]=array_merge($val->toArray(), $abc_arr);

                            }

                        }

                    }

                    $def_arr['site_subject_examination_exam_type_mark']=collect($abc_array)->values();
                    $def_arr['examination_id']=$valu->examination_id;

                    $def_array[$ke]=array_merge($def_arr);

                }

                $subject_list_arr['site_subject_examination_mark']=$def_array;
                $subject_list_arr['subject_name']=$value->subject_name;
                $subject_list_arr['select_subject_id']=false;
                $subject_list_arr['id']=$value->id;
                $subject_list_arr['academic_subject_id']=$value->academic_subject_id;
                $subject_list_array[$key]=array_merge($subject_list_arr);
            }

            $examSubjectids=$subjects->pluck('id')
                ->unique()
                ->filter();

            $examinationIDs=SiteSubjectExaminationMark::where('examination_id', $requests->examination_id)
                ->whereIn('site_subject_group_condition_setting_id', $examSubjectids)
                ->where('status', true)
                ->pluck('id')
                ->unique()
                ->filter();

            $examTypeIDs=SiteSubjectExaminationExamTypeMark::whereIn('site_subject_examination_mark_id', $examinationIDs)
                ->where('status', true)
                ->pluck('academic_exam_type_id')
                ->unique()
                ->filter();
  // dd($examTypeIDs);
            $examTypeLists=AcademicExamType::whereIn('id', $examTypeIDs)->get();


            $exam_type_list_arr=Array();
            $exam_type_list_array=[];

            foreach ($examTypeLists as $key => $value) {

                $exam_type_list_arr['start_time']=null;
                $exam_type_list_arr['end_time']=null;
                $exam_type_list_arr['duration']=null;

                $exam_type_list_array[$key]=array_merge($value->toArray(), $exam_type_list_arr);
            }


//            $examList=$this->getSiteBaseDeclaredExamList($requests);

            $checkSiteExamDeclared=SiteExamDeclares::where('academic_version_id', $requests->academic_version_id)
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->where('academic_class_id', $requests->academic_class_id)
                ->where('examination_id', $requests->examination_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->where('status', true)
              //  ->where('exam_declared_by','site')
                ->first();

                if($checkSiteExamDeclared){
                    $siteExamDeclaredId=$checkSiteExamDeclared->id;
                    $siteGroupExamDeclaredStatus=$checkSiteExamDeclared->exam_declared_by=='site'?true:false;
                }else{
                    $siteExamDeclaredId=0;
                    $siteGroupExamDeclaredStatus=true;
                }

                //dd($checkSiteExamDeclared);

            $active_student_history_id = $student_array->pluck('id');

            $declared_student_ids=SiteExamDeclareStudent::where('site_exam_declare_id',$siteExamDeclaredId)
                ->whereIn('student_history_id',$active_student_history_id)
                ->where('status', true)
                ->pluck('student_history_id')
                ->unique()
                ->filter();

            $checkRoutine=SiteExamRoutine::where('site_exam_declare_id',$siteExamDeclaredId)->where('status', true)->first();

            if($checkRoutine){
                $examTypeList = SiteExamDeclares::with(['version', 'year', 'shift', 'department',
                    'stClass', 'session', 'section',
                    'examRoutine', 'examination',
                    'academicExamTypeList'=>function($query){
                        $query->groupBy('academic_exam_type_id');
                    },

                ])
                    ->withCount('declaredStudent')
                    ->where('academic_version_id', $requests->academic_version_id)
                    ->where('academic_year_id', $requests->academic_year_id)
                    ->where('academic_shift_id', $requests->academic_shift_id)
                    ->where('academic_class_id', $requests->academic_class_id)
                    ->where('examination_id', $requests->examination_id)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->where('status', true)
                   // ->where('exam_declared_by','site')
                    ->get();

            }else{

                $examTypeList = SiteExamDeclares::with(['version', 'year', 'shift', 'department',
                    'stClass', 'session', 'section','examRoutine',
                    'examination'
                ])
                    ->withCount('declaredStudent')
                    ->where('academic_version_id', $requests->academic_version_id)
                    ->where('academic_year_id', $requests->academic_year_id)
                    ->where('academic_shift_id', $requests->academic_shift_id)
                    ->where('academic_class_id', $requests->academic_class_id)
                    ->where('examination_id', $requests->examination_id)
                    ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                        return $query->where('academic_department_id', $data['academic_department_id']);
                    })
                    ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                        return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                    })
                    ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                        return $query->where('academic_section_id', $data['academic_section_id']);
                    })
                    ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                        return $query->where('academic_session_id', $data['academic_session_id']);
                    })
                    ->where('status', true)
                 //   ->where('exam_declared_by','site')
                    ->get();

            }
        //    dd(count($studentList));
            return response()->json(
                [
                    'studentList' => $studentList,
                    'subject_list_array' => $subject_list_array,
                    'exam_type_list_array' => $exam_type_list_array,
                    'examTypeList' => $examTypeList,
                    'select_student_user_id' => $declared_student_ids,
                    'select_student_user_id' => $declared_student_ids,
                    'siteGroupExamDeclaredStatus' => $siteGroupExamDeclaredStatus,
                ]);

        } catch (Exception $exception) {
            return Response::json(['message' => $exception->getMessage()], 410);
        }

    }

    public function getSiteBaseExamRoutineList(Request $request){

        $data=$request->all();

        $site_subject_group_condition_setting_ids=SiteExamDeclareStudentSubject::where('site_exam_declare_id',$data['exam_declare_id'])
            ->where('status', true)
            ->pluck('site_subject_group_condition_setting_id')
            ->unique()
            ->values();
        $subject_array=[];
        foreach($site_subject_group_condition_setting_ids as $key=>$subject_condition_setting_id){
            $checkRoutine=SiteExamRoutine::with('subjectGroupConditionSetting')
                ->where('site_exam_declare_id',$data['exam_declare_id'])
                ->where('site_subject_group_condition_setting_id',$subject_condition_setting_id)
                ->get();

            $subject_conditin= SubjectGroupConditionSetting::where('id',$subject_condition_setting_id)->first();

                $exam_type_array=[];
                $keys=0;
                foreach($checkRoutine as $routine){
                    $exam_type_array[$keys]['id']=$routine->id;
                    $exam_type_array[$keys]['site_subject_group_condition_setting_id']=$routine->site_subject_group_condition_setting_id;
                    $exam_type_array[$keys]['site_exam_declare_id']=$routine->site_exam_declare_id;
                    $exam_type_array[$keys]['online_exam_status']=$routine->online_exam_status;
                    $exam_type_array[$keys]['academic_exam_type_id']=$routine->academic_exam_type_id;
                    $exam_type_array[$keys]['exam_type_name']=$routine->academicExamType->marks_type;
                    $exam_type_array[$keys]['exam_start_date']=$routine->exam_start_date;
                    $exam_type_array[$keys]['exam_end_date']=$routine->exam_end_date;
                    $exam_type_array[$keys]['exam_start_time']=$routine->exam_start_time;
                    $exam_type_array[$keys]['exam_end_time']=$routine->exam_end_time;
                    $exam_type_array[$keys]['exam_duration']=$routine->exam_duration;
                    $keys++;
                }

            $subject_array[$key]['subject_name']=$subject_conditin->subject_name;
            $subject_array[$key]['site_subject_group_condition_setting_id']=$subject_condition_setting_id;
            $subject_array[$key]['exam_type_array']=$exam_type_array;

            }

            $examination=Examination::where('id', $request->examination_id)->first();
            $examination_name=$examination->examination_name;

            $year=AcademicYear::where('id', $request->academic_year_id)->first();
            $year_name=$year->year_name;

            $shift=AcademicShift::where('id', $request->academic_shift_id)->first();
            $shift_name=$shift->shift_name;

            $AcademicClass=AcademicClass::where('id', $request->academic_class_id)->first();
            $class_name=$AcademicClass->class_name;

            //description
            $institute_head = Employee::where('institute_head', 1)->first();
            $signature = $institute_head->signature ?? '/img/signature/signature.png';

            $site = SiteInfo::findOrFail(Session::get('SITE_ID'));

            $report_tittle='';
            $page_tittle='';
            $report_tittle2='';
            $title_view='';
            $signature='';
            $req_data ='';

            $view = View::make('default.admin.site.exam.report.exam-routine-pdf',
            compact('subject_array', 'examination_name', 'year_name', 'report_tittle',
                'page_tittle', 'report_tittle2', 'title_view','signature','site','req_data','class_name','shift_name'));
         //   ->setWarnings(false);


        // $path = storage_path() . '/pdf';
        // $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        // $pdf->save($path . '/' . $time . '.pdf', 'UTF-8');
        // $name = $time . '.pdf';


        $contents = $view->render();

        $path = storage_path() . '/pdf';

        $mpdf = new \Mpdf\Mpdf();
        $mpdf->autoScriptToLang = true;
        $mpdf->autoLangToFont = true;
        $mpdf->allow_charset_conversion = false;
        $mpdf->WriteHTML($contents);
      //  $time = 'admission-form-'.$site_list->site_alias.'-'.$file_name_combination . '-' . Carbon::now()->unix();
        $time = \Auth::user()->id . '-' . Carbon::now()->unix();
        $mpdf->Output($path . '/' . $time . '.pdf', 'F');
        $name = $time . '.pdf';

        return Response::json(['link' => route('open-pdf-file-storage', [$name]),
            'message' => 'Successfully Created Card Report'], 200);



       // return $subject_array;


    }

//     public function createSiteBaseNewExamDeclare(siteExamDeclares $siteExamDeclares, Request $requests){

//         DB::beginTransaction();

//         try {

//         $subjects=[];
//         foreach ($requests->SubjectExamTypeList as $key => $value) {
//             if($value['select_subject_id']){
//                 foreach ($value['site_subject_examination_mark'] as $keys => $values) {
//                     foreach ($values['site_subject_examination_exam_type_mark'] as $keyst => $valuest) {
//                         if($valuest['select_exam_type_id']){
//                             $subjects[]=$value['id'];
//                         }
//                     }
//                 }
//             }
//         }


//         $selected_subject_ids= array_unique($subjects);

//         $siteExamDeclares->academic_version_id=$requests->academic_version_id;
//         $siteExamDeclares->academic_year_id=$requests->academic_year_id;
//         $siteExamDeclares->academic_shift_id=$requests->academic_shift_id;
//         $siteExamDeclares->academic_department_id=$requests->academic_department_id;
//         $siteExamDeclares->academic_class_id=$requests->academic_class_id;
//         $siteExamDeclares->academic_class_group_id=$requests->academic_class_group_id;
//         $siteExamDeclares->academic_session_id=$requests->academic_session_id;
//         $siteExamDeclares->academic_section_id=$requests->academic_section_id;

//         $siteExamDeclares->examination_id=$requests->examination_id;
//         $siteExamDeclares->site_subject_group_condition_setting_ids=implode(',', $selected_subject_ids);

//         $siteExamDeclares->created_by=Auth::user()->id;
//         $siteExamDeclares->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
//         $siteExamDeclares->site_id=Session::get('SITE_ID');
//         $siteExamDeclares->status=true;


//         if($siteExamDeclares->save()){
//             $siteExamDeclare_id = $siteExamDeclares->id;
//         }

//         $data = $requests->all();

//         $subject_group_condition_Setting_ids=SubjectGroupConditionSetting::
//         where('academic_year_id', $data['academic_year_id'])
//             ->where('academic_class_id', $data['academic_class_id'])
//             ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
//                 return $query->where('academic_department_id', $data['academic_department_id']);
//             })
//             ->pluck('id');

//         $site_subject_examination_mark_ids=SiteSubjectExaminationMark::
//             whereIn('site_subject_group_condition_setting_id', $subject_group_condition_Setting_ids)
//             ->where('examination_id', $requests->examination_id)
//             ->pluck('id');


//         $academic_exam_type_ids=SiteSubjectExaminationExamTypeMark::
//         whereIn('site_subject_examination_mark_id', $site_subject_examination_mark_ids)
//             ->distinct('academic_exam_type_id')
//             ->pluck('academic_exam_type_id')->unique()->filter();

// //return $academic_exam_type_ids->toArray();

//         if(count($requests->select_student_user_id)>0 ){
//             $created=[];
//             foreach ($requests->select_student_user_id as $key => $value) {
//                 $created[] = [
//                     'site_exam_declare_id' => $siteExamDeclare_id,
//                     'student_history_id' => $value,
//                     'academic_exam_type_ids' => implode(',' , $academic_exam_type_ids->toArray()),
//                     'status' => true,
//                     'site_id' => Session::get('SITE_ID'),

//                 ];
//             }

//             if(count($created)>0){

//                 SiteExamDeclareStudent::insert($created);

//             }

//         }

//         $NewSiteExamDeclareStudentList=SiteExamDeclareStudent::whereIn('student_history_id', $requests->select_student_user_id)
//             ->where('site_exam_declare_id', $siteExamDeclare_id)
//             ->where('status', true)
//             ->select('id', 'student_history_id', 'site_exam_declare_id')
//             ->get();
//         $StudentSubjectList=StudentHistory::whereIn('id', $requests->select_student_user_id)
//             ->where('status', true)
//             ->get(['id', 'academic_subject_ids']);

//         $createds=[];
//         foreach ($requests->SubjectExamTypeList as $key => $value) {

//             if($value['select_subject_id']){
//                 foreach ($value['site_subject_examination_mark'] as $keys => $values) {

//                     foreach ($values['site_subject_examination_exam_type_mark'] as $keyst => $valuest) {
//                         if($valuest['select_exam_type_id']){
//                             $routineCreate=new SiteExamRoutine();

//                             $routineCreate->site_exam_declare_id=$siteExamDeclare_id;
//                             $routineCreate->site_subject_group_condition_setting_id=$value['id'];
//                             $routineCreate->academic_exam_type_id=$valuest['academic_exam_type_id'];
//                             $routineCreate->online_exam_status=$valuest['online_exam_status'];
//                             $routineCreate->online_result_show_student=$valuest['online_result_show_student'];
//                             $routineCreate->exam_start_date=$valuest['start_date'];
//                             $routineCreate->exam_end_date=$valuest['end_date'];
//                             $routineCreate->exam_start_time=date("H:i", strtotime($valuest['start_time']));
//                             $routineCreate->exam_end_time=date("H:i", strtotime($valuest['end_time']));
//                             $routineCreate->exam_duration=$valuest['duration'];
//                             $routineCreate->per_day_student=$valuest['student_per_day'];
//                             $routineCreate->examination_id=$requests->examination_id;
//                             $routineCreate->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
//                             $routineCreate->site_id=Session::get('SITE_ID');
//                             $routineCreate->status=true;

//                             $routineCreate->save();
//                             $siteExamRoutine_id = $routineCreate->id;

//                             foreach ($requests->select_student_user_id as $keyp => $valuep) {

//                                $getSiteExamDeclareStudent= $NewSiteExamDeclareStudentList
//                                    ->where('student_history_id', $valuep)
//                                    ->first();


//                                 $getStudent=$StudentSubjectList
//                                     ->where('id', $valuep)
//                                     ->first();
//                                 $collection = collect(($getStudent->academic_subject_ids)[1]);


//                                 $checkvalue=[];
//                                 foreach ($collection as $keyw => $valuew) {
//                                     if($valuew==$value['academic_subject_id']){
//                                         $checkvalue[]=$value['academic_subject_id'];
//                                     }
//                                 }

//                                 if(count($checkvalue)>0){


//                                     $createds[] = [
//                                         'site_exam_declare_id' => $siteExamDeclare_id,
//                                         'examination_id' => $requests->examination_id,
//                                         'site_exam_declare_student_id' => $getSiteExamDeclareStudent->id,
//                                         'academic_exam_type_id' => $valuest['academic_exam_type_id'],
//                                         'site_exam_routine_id' => $siteExamRoutine_id,
//                                         'online_exam_status' => $valuest['online_exam_status']?true:false,
//                                         'subject_exam_type_mark' => $valuest['marks'],
//                                         'pass_mark' => $valuest['pass_marks'],

//                                         'exam_type_countable_marks_status' => $valuest['countable_marks_status'],
//                                         'exam_type_countable_marks' => $valuest['countable_marks'],
//                                         'exam_type_countable_persent_of_obtain_marks' => $valuest['countable_persent_of_obtain_marks'],

//                                         'student_history_id' => $valuep,
//                                         'site_subject_group_condition_setting_id' => $value['id'],
//                                         'status' => true,
//                                         'site_id' => Session::get('SITE_ID'),

//                                     ];
//                                 }
//                             }

//                         }
//                     }
//                 }

//             }
//         }



//         if(count($createds)>0){
//             SiteExamDeclareStudentSubject::insert($createds);
//         }
//             DB::commit();
//             return Response::json(['message' => 'Save Successfully!', 'mode' => 'Update!'], 200);

//         } catch (ValidationException $exception) {
//             DB::rollBack();
//             return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
//         } catch (Exception $exception) {
//             DB::rollBack();
//             return Response::json(['message' => $exception->getMessage()], 410);
//         }
//     }


    public function getSiteBaseDeclaredExamList(Request $request){

        $data = $request->all();

        $checkSiteExamDeclared=SiteExamDeclares::where('academic_version_id', $request->academic_version_id)
            ->where('academic_year_id', $request->academic_year_id)
            ->where('academic_shift_id', $request->academic_shift_id)
            ->where('academic_class_id', $request->academic_class_id)
            ->where('examination_id', $request->examination_id)
            ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                return $query->where('academic_department_id', $data['academic_department_id']);
            })
            ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                return $query->where('academic_class_group_id', $data['academic_class_group_id']);
            })
            ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                return $query->where('academic_section_id', $data['academic_section_id']);
            })
            ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                return $query->where('academic_session_id', $data['academic_session_id']);
            })
            ->pluck('id');



        $checkRoutine=SiteExamRoutine::whereIn('site_exam_declare_id',$checkSiteExamDeclared)->first();


        if($checkRoutine){
            $examList = SiteExamDeclares::with(['version', 'year', 'shift', 'department',
                'stClass', 'session', 'section', 'declaredStudent',
                'examRoutine', 'examination',
                'academicExamTypeList'=>function($query){
                    $query->groupBy('academic_exam_type_id');
                },

            ])
                ->withCount('declaredStudent')
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('examination_id', $request->examination_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->get();

        }else{

            $examList = SiteExamDeclares::with(['version', 'year', 'shift', 'department',
                'stClass', 'session', 'section', 'declaredStudent','examRoutine',
                'examination'
            ])
                ->withCount('declaredStudent')
                ->where('academic_version_id', $request->academic_version_id)
                ->where('academic_year_id', $request->academic_year_id)
                ->where('academic_shift_id', $request->academic_shift_id)
                ->where('academic_class_id', $request->academic_class_id)
                ->where('examination_id', $request->examination_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->when(!empty($data['academic_class_group_id']), function ($query) use ($data) {
                    return $query->where('academic_class_group_id', $data['academic_class_group_id']);
                })
                ->when(!empty($data['academic_section_id']), function ($query) use ($data) {
                    return $query->where('academic_section_id', $data['academic_section_id']);
                })
                ->when(!empty($data['academic_session_id']), function ($query) use ($data) {
                    return $query->where('academic_session_id', $data['academic_session_id']);
                })
                ->get();

        }

        return $examList;

    }

    public function deleteSiteBaseExamDeclare(Request $requests){

        DB::beginTransaction();
        dd('rr');

        try {

            $number_entry=SiteExamDeclareStudentSubject::
                where('site_exam_declare_id', $requests->exam_declare_id)
                ->where('exam_attendance_status', true)
                ->first();

            if($number_entry){
                return Response::json(['message' => 'You Can not delete this Exam!', 'mode' => 'error'], 412);
            }else{
                SiteExamDeclares::where('id', $requests->exam_declare_id)->delete();
                SiteExamDeclareStudent::where('site_exam_declare_id', $requests->exam_declare_id)->delete();
                SiteExamRoutine::where('site_exam_declare_id', $requests->exam_declare_id)->delete();
                SiteExamDeclareStudentSubject::where('site_exam_declare_id', $requests->exam_declare_id)->delete();
            }

            DB::commit();
            return Response::json(['message' => 'Delete Successfully!', 'mode' => 'Update!'], 200);

        } catch (ValidationException $exception) {
            DB::rollBack();
            return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
        } catch (Exception $exception) {
            DB::rollBack();
            return Response::json(['message' => $exception->getMessage()], 410);
        }
    }


    public function updateSiteBaseNewExamDeclare(siteExamDeclares $siteExamDeclares,Request $requests){


       DB::beginTransaction();

        try {

            $data = $requests->all();

            $check_declared_list=SiteExamDeclares::where('academic_version_id', $requests->academic_version_id)
                ->where('academic_year_id', $requests->academic_year_id)
                ->where('academic_shift_id', $requests->academic_shift_id)
                ->where('academic_class_id', $requests->academic_class_id)
                ->where('examination_id', $requests->examination_id)
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('status',true)
                ->first();

            if($requests->first_time_update==1){

                $subjects=[];
                foreach ($requests->SubjectExamTypeList as $key => $value) {
                    if($value['select_subject_id']){

                        foreach ($value['site_subject_examination_mark'] as $keys => $values) {
                            foreach ($values['site_subject_examination_exam_type_mark'] as $keyst => $valuest) {
                                if($valuest['select_exam_type_id']){
                                    $subjects[]=$value['id'];
                                }
                                else{
                                    if($check_declared_list){
                                        $check_exam_type_held=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $check_declared_list->id)
                                            ->where('examination_id', $requests->examination_id)
                                            ->where('site_subject_group_condition_setting_id', $value['id'])
                                            ->where('academic_exam_type_id', $valuest['academic_exam_type_id'])
                                            ->where('exam_attendance_status', true)
                                            ->first();
                                        if($check_exam_type_held){
                                            $subjects[]=$value['id'];
                                        }
                                    }

                                }

                            }
                        }
                    }
                    else{
                        if($check_declared_list){
                            $check_exam_held=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $check_declared_list->id)
                                ->where('examination_id', $requests->examination_id)
                                ->where('site_subject_group_condition_setting_id', $value['id'])
                                ->where('exam_attendance_status', true)
                                ->first();
                            if($check_exam_held){
                                $subjects[]=$value['id'];
                            }
                        }

                    }
                }
                $selected_subject_ids= collect($subjects)->unique()->values()->toArray();

                if($check_declared_list){
                    // site and sitegroup
                    $check_declared_list->site_subject_group_condition_setting_ids=implode(',', $selected_subject_ids);
                    $check_declared_list->save();

                    ///=====

                    $declaredSiteExam=SiteExamDeclares::where('id', $check_declared_list->id)
                            ->where('exam_declared_by','site')
                            ->first();

                    if($declaredSiteExam){

                        $declaredSiteExam->academic_version_id=$requests->academic_version_id;
                        $declaredSiteExam->academic_year_id=$requests->academic_year_id;
                        $declaredSiteExam->academic_shift_id=$requests->academic_shift_id;
                        $declaredSiteExam->academic_department_id=$requests->academic_department_id;
                        $declaredSiteExam->academic_class_id=$requests->academic_class_id;
                        $declaredSiteExam->academic_class_group_id=$requests->academic_class_group_id;
                        $declaredSiteExam->academic_session_id=$requests->academic_session_id;
                        $declaredSiteExam->academic_section_id=$requests->academic_section_id;

                        $declaredSiteExam->examination_id=$requests->examination_id;
                //        $declaredSiteExam->site_subject_group_condition_setting_ids=implode(',', $selected_subject_ids);
                        $declaredSiteExam->save();
                    }
                    $siteExamDeclare_id=$check_declared_list->id;

                }else{

                $examination=Examination::where('id',$requests->examination_id)->where('use_key','site')->first();
                if($examination){

                    $siteExamDeclares=new SiteExamDeclares;
                    $siteExamDeclares->academic_version_id=$requests->academic_version_id;
                    $siteExamDeclares->academic_year_id=$requests->academic_year_id;
                    $siteExamDeclares->academic_shift_id=$requests->academic_shift_id;
                    $siteExamDeclares->academic_department_id=$requests->academic_department_id;
                    $siteExamDeclares->academic_class_id=$requests->academic_class_id;
                    $siteExamDeclares->academic_class_group_id=$requests->academic_class_group_id;
                    $siteExamDeclares->academic_session_id=$requests->academic_session_id;
                    $siteExamDeclares->academic_section_id=$requests->academic_section_id;

                    $siteExamDeclares->examination_id=$requests->examination_id;
                    $siteExamDeclares->site_subject_group_condition_setting_ids=implode(',', $selected_subject_ids);
                    $siteExamDeclares->created_by=Auth::user()->id;
                    $siteExamDeclares->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
                    $siteExamDeclares->site_id=Session::get('SITE_ID');
                    $siteExamDeclares->status=true;

                    if($siteExamDeclares->save()){
                        $siteExamDeclare_id = $siteExamDeclares->id;
                    }
                }else{
                    return Response::json(['message'=>'It is a group exam, You have no permission!'],410);
                }
                }
            }
            else{
                $siteExamDeclare_id=$check_declared_list->id;

            }

            $subject_group_condition_Setting_ids=SubjectGroupConditionSetting::
                where('academic_year_id', $data['academic_year_id'])
                ->where('academic_class_id', $data['academic_class_id'])
                ->when(!empty($data['academic_department_id']), function ($query) use ($data) {
                    return $query->where('academic_department_id', $data['academic_department_id']);
                })
                ->where('status', true)
              //  ->where('id', 12256)
                ->pluck('id');

            $site_subject_examination_mark_ids=SiteSubjectExaminationMark::
            whereIn('site_subject_group_condition_setting_id', $subject_group_condition_Setting_ids)
                ->where('examination_id', $requests->examination_id)
                ->where('status', true)
                ->pluck('id');
             //   dd($site_subject_examination_mark_ids);

            $academic_exam_type_ids=SiteSubjectExaminationExamTypeMark::whereIn('site_subject_examination_mark_id', $site_subject_examination_mark_ids)
                ->distinct('academic_exam_type_id')
                ->pluck('academic_exam_type_id')->unique()->filter();

            if($check_declared_list){
                $declaredStudent=SiteExamDeclareStudent::where('site_exam_declare_id', $check_declared_list->id)->get();
                $declaredStudentIds=$declaredStudent->pluck('id');
            }

            if($requests->first_time_update==1){


                $declared_student_id=[];
                $created=[];
                if(count($requests->select_student_user_id)>0 ){

                    foreach ($requests->select_student_user_id as $key => $value) {

                        if($check_declared_list){
                            $checkStudent=$declaredStudent->where('student_history_id', $value)->first();
                        }else{
                            $checkStudent=0;
                        }
                        if($checkStudent){
                            $declared_student_id[]=$checkStudent->id;

                            $checkStudent->update([
                                'academic_exam_type_ids' => implode(',', $academic_exam_type_ids->toArray()),
                                'status' => true
                            ]);

                        }else{
                            $created[] = [
                                'site_exam_declare_id' => $siteExamDeclare_id,
                                'student_history_id' => $value,
                                'academic_exam_type_ids' => implode(',', $academic_exam_type_ids->toArray()),
                                'status' => true,
                                'site_id' => Session::get('SITE_ID'),
                            ];
                        }
                    }


                }

                if($check_declared_list){

                    $check_student_exam_attendance=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $check_declared_list->id)
                        ->where('examination_id', $requests->examination_id)
                        ->where('exam_attendance_status', true)
                        ->pluck('site_exam_declare_student_id')
                        ->unique()
                        ->values()
                        ->toArray();

                    $array_combine=collect(array_merge($check_student_exam_attendance, $declared_student_id))->unique()->values()->toArray();
                    $siteExamStudentCheck=array_diff($declaredStudentIds->toArray(), $array_combine);
                    SiteExamDeclareStudentSubject::whereIn('site_exam_declare_student_id', $siteExamStudentCheck)->update(['status' => false]);
                    SiteExamDeclareStudent::whereIn('id', $siteExamStudentCheck)->update(['status' => false]);
                }
                if(count($created)>0){

                    SiteExamDeclareStudent::insert($created);

                }
            }

            $count_student=count($requests->select_student_user_id);



            if($requests->first_time_update==1){

                $ten_student_history_id=collect($requests->select_student_user_id)->take(10);
                $studentRest=array_diff($requests->select_student_user_id, $ten_student_history_id->toArray());


                $completed_student_id_array=$ten_student_history_id;

            }
            else if($requests->first_time_update==0){

                $ten_student_history_id=collect($requests->select_student_rest_history_id)->take(20);
                $studentRest=array_diff($requests->select_student_rest_history_id, $ten_student_history_id->toArray());


                $completed_student_id_array=array_merge($requests->completed_student_id_array, $ten_student_history_id->toArray());
            }

            $completed_percent=ceil(count($completed_student_id_array)*100/$count_student);

            $NewSiteExamDeclareStudentList=SiteExamDeclareStudent::whereIn('student_history_id', $ten_student_history_id)
                ->where('site_exam_declare_id', $siteExamDeclare_id)
                ->where('status', true)
                ->select('id', 'student_history_id', 'site_exam_declare_id')
                ->get();

            $StudentSubjectList=StudentHistory::whereIn('id', $ten_student_history_id)
                ->where('status', true)
                ->get(['id', 'academic_subject_ids','user_id']);

            $declaredRoutine=SiteExamRoutine::where('site_exam_declare_id', $siteExamDeclare_id)->get();
            $declaredRoutineIds=$declaredRoutine->pluck('id')->toArray();

            $declaredStudentRoutine=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $siteExamDeclare_id)
                ->whereIn('student_history_id',$ten_student_history_id)
                ->get();
            $declaredStudentRoutineIds=$declaredStudentRoutine->pluck('id');
            $studentRoutineIds=[];
            $routineIDs=[];
            $createds=[];
            $unchecked_sub_held_student_list=[];
            $unchecked_sub_held_routine_list=[];

            foreach ($requests->SubjectExamTypeList as $key => $value) {

                if($value['select_subject_id']){
                    foreach ($value['site_subject_examination_mark'] as $keys => $values) {

                        foreach ($values['site_subject_examination_exam_type_mark'] as $keyst => $valuest) {

                            if($valuest['select_exam_type_id']){



                                if($requests->first_time_update==1){
                                    if($valuest['routine_id']){

                                        if($valuest['start_date']){
                                            $Routines=$declaredRoutine->where('id', $valuest['routine_id'])->first();

                                            $routineIDs[]=$valuest['routine_id'];

                                            $Routines->site_subject_group_condition_setting_id=$value['id'];
                                            $Routines->academic_exam_type_id=$valuest['academic_exam_type_id'];
                                            $Routines->online_exam_status=$valuest['online_exam_status']?true:false;
                                            $Routines->online_result_show_student=$valuest['online_result_show_student']?true:false;
                                            $Routines->exam_start_date=$valuest['start_date'];
                                            $Routines->exam_end_date=$valuest['end_date'];
                                            $Routines->exam_start_time=date("H:i", strtotime($valuest['start_time']));
                                            $Routines->exam_end_time=date("H:i", strtotime($valuest['end_time']));
                                            $Routines->exam_duration=$valuest['duration'];
                                            $Routines->per_day_student=$valuest['student_per_day'];

                                            if($check_declared_list->exam_declared_by=='site'){
                                                $Routines->save();
                                            }
                                            $siteExamRoutine_id =  $valuest['routine_id'];
                                        }
                                        else{
                                            $routineIDs[]=$valuest['routine_id'];

                                            $siteExamRoutine_id =  $valuest['routine_id'];

                                            $Routines=$declaredRoutine->where('id', $valuest['routine_id'])->first();
                                            $Routines->online_exam_status=$valuest['online_exam_status']?true:false;
                                            $Routines->online_result_show_student=$valuest['online_result_show_student']?true:false;
                                            $Routines->status=true;
                                            if($check_declared_list->exam_declared_by=='site'){
                                                $Routines->save();
                                            }
                                        }

                                    }
                                    else{
                                        $routineCreate=new SiteExamRoutine();

                                        $routineCreate->site_exam_declare_id=$siteExamDeclare_id;
                                        $routineCreate->site_subject_group_condition_setting_id=$value['id'];
                                        $routineCreate->academic_exam_type_id=$valuest['academic_exam_type_id'];
                                        $routineCreate->online_exam_status=$valuest['online_exam_status']?true:false;
                                        $routineCreate->online_result_show_student=$valuest['online_result_show_student']?true:false;
                                        $routineCreate->exam_start_date=$valuest['start_date'];
                                        $routineCreate->exam_end_date=$valuest['end_date'];
                                        $routineCreate->exam_start_time=date("H:i", strtotime($valuest['start_time']));
                                        $routineCreate->exam_end_time=date("H:i", strtotime($valuest['end_time']));
                                        $routineCreate->exam_duration=$valuest['duration'];
                                        $routineCreate->per_day_student=$valuest['student_per_day'];

                                        $routineCreate->examination_id=$requests->examination_id;
                                        $routineCreate->academic_group_id=Session::get('ACADEMIC_GROUP_ID');
                                        $routineCreate->site_id=Session::get('SITE_ID');
                                        $routineCreate->status=true;

                                        $routineCreate->save();
                                        $siteExamRoutine_id = $routineCreate->id;
                                    }
                                }
                                else{

                                    $checkRountin=$declaredRoutine
                                        ->where('site_subject_group_condition_setting_id', $value['id'])
                                        ->where('academic_exam_type_id', $valuest['academic_exam_type_id'])
                                        ->first();
                                    $siteExamRoutine_id=$checkRountin->id;
                                }

                                foreach ($ten_student_history_id as $keyp => $valuep) {

                                    $getSiteExamDeclareStudent= $NewSiteExamDeclareStudentList
                                        ->where('student_history_id', $valuep)
                                        ->first();

                                    $getStudent=$StudentSubjectList
                                        ->where('id', $valuep)
                                        ->first();

                                    $collection = collect(($getStudent->academic_subject_ids)[1]);


                                    $checkvalue=[];

                                    foreach ($collection as $keyw => $valuew) {
                                        if($valuew==$value['academic_subject_id']){
                                            $checkvalue[]=$value['academic_subject_id'];
                                        }
                                    }


                                    if(count($checkvalue)>0){
                                        $checkStudentRoutine=$declaredStudentRoutine
                                            ->where('examination_id',$requests->examination_id)
                                            ->where('site_subject_group_condition_setting_id', $value['id'])
                                            ->where('academic_exam_type_id',$valuest['academic_exam_type_id'])
                                            ->where('student_history_id',$valuep)
                                            ->where('site_exam_routine_id', $siteExamRoutine_id)
                                            ->first();

                                          //  dd($valuest);

                                        if($checkStudentRoutine){

                                            //==== this condition add for exam type countable mark
                                            if($valuest['status']){
                                                $checkStudentRoutine->exam_type_countable_marks=$valuest['countable_marks'];
                                            }else{
                                                $checkStudentRoutine->exam_type_countable_marks=0;
                                            }
                                            $checkStudentRoutine->exam_type_countable_marks_status=$valuest['countable_marks_status'];
                                            $checkStudentRoutine->exam_type_countable_persent_of_obtain_marks=$valuest['countable_persent_of_obtain_marks'];

                                            if(!is_null($checkStudentRoutine->obtaine_marks)){
                                                if($checkStudentRoutine['exam_type_countable_marks_status']){
                                                $countable_obtaine_marks = ($valuest['countable_persent_of_obtain_marks'] * $checkStudentRoutine->obtaine_marks)/100;

                                            }else{
                                                $countable_obtaine_marks = $checkStudentRoutine->obtaine_marks;
                                                }

                                                $checkStudentRoutine->countable_obtaine_marks=$countable_obtaine_marks;

                                            }
                                            //===


                                            if($valuest['marks']==$checkStudentRoutine->subject_exam_type_mark &&
                                                $checkStudentRoutine->pass_mark==$valuest['pass_marks']){
                                                $studentRoutineIds[]=$checkStudentRoutine->id;
                                                $checkStudentRoutine->online_exam_status=$valuest['online_exam_status']?true:false;
                                                $checkStudentRoutine->status=true;
                                                $checkStudentRoutine->save();

                                            }else{
                                                $studentRoutineIds[]=$checkStudentRoutine->id;
                                                $checkStudentRoutine->site_subject_group_condition_setting_id=$value['id'];
                                                $checkStudentRoutine->site_exam_declare_student_id=$getSiteExamDeclareStudent->id;
                                                $checkStudentRoutine->online_exam_status=$valuest['online_exam_status']?true:false;
                                                $checkStudentRoutine->subject_exam_type_mark=$valuest['marks'];
                                                $checkStudentRoutine->pass_mark=$valuest['pass_marks'];
                                                $checkStudentRoutine->status=true;
                                                $checkStudentRoutine->save();
                                            }

                                        }
                                        else{

                                            if($valuest['status']){
                                                $exam_type_countable_marks=$valuest['countable_marks'];
                                            }else{
                                                $exam_type_countable_marks=0;
                                            }

                                            $createds[] = [
                                                'site_exam_declare_id' => $siteExamDeclare_id,
                                                'examination_id' => $requests->examination_id,
                                                'site_exam_declare_student_id' => $getSiteExamDeclareStudent->id,
                                                'academic_exam_type_id' => $valuest['academic_exam_type_id'],
                                                'site_exam_routine_id' => $siteExamRoutine_id,
                                                'online_exam_status' => $valuest['online_exam_status']?true:false,
                                                'subject_exam_type_mark' => $valuest['marks'],
                                                'pass_mark' => $valuest['pass_marks'],

                                                //==== this column add for exam type countable mark
                                                'exam_type_countable_marks_status' => $valuest['countable_marks_status'],
                                                'exam_type_countable_marks' => $exam_type_countable_marks,
                                                'exam_type_countable_persent_of_obtain_marks' => $valuest['countable_persent_of_obtain_marks'],
                                                //===
                                                'student_history_id' => $valuep,
                                                'site_subject_group_condition_setting_id' => $value['id'],
                                                'status' => true,
                                                'site_id' => Session::get('SITE_ID'),

                                            ];
                                        }

                                    }
                                }

                            }
                            else{
                                if($check_declared_list){
                                    $check_exam_type_held=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $check_declared_list->id)
                                        ->where('examination_id', $requests->examination_id)
                                        ->where('site_subject_group_condition_setting_id', $value['id'])
                                        ->where('academic_exam_type_id', $valuest['academic_exam_type_id'])
                                        ->where('exam_attendance_status', true)
                                        ->first();

                                    if($check_exam_type_held){
                                        if($requests->first_time_update==1){
                                            $Routines_check=$declaredRoutine->where('id', $valuest['routine_id'])->first();
                                            if($Routines_check){
                                                $routineIDs[]=$valuest['routine_id'];
                                            }

                                        }

                                        $checkStudentSubject_ids=$declaredStudentRoutine
                                            ->where('examination_id',$requests->examination_id)
                                            ->where('academic_exam_type_id',$valuest['academic_exam_type_id'])
                                            ->where('site_exam_routine_id', $valuest['routine_id'])
                                            ->pluck('id');

                                        if(count($checkStudentSubject_ids)>0){
                                            foreach ($checkStudentSubject_ids as $keywtt => $valuewtt) {
                                                $studentRoutineIds[]=$valuewtt;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }

                }
                else{

                    if($check_declared_list){
                        $check_exam_held_status=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $check_declared_list->id)
                            ->where('examination_id', $requests->examination_id)
//                        ->whereIn('student_history_id', $ten_student_history_id)
                            ->where('site_subject_group_condition_setting_id', $value['id'])
                            ->where('exam_attendance_status', true)
                          //  ->where('status', true)
                            ->first();

                        if($check_exam_held_status){
                            $unchecked_sub_held_student_list[]=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $check_declared_list->id)
                                ->where('examination_id', $requests->examination_id)
                                ->whereIn('student_history_id', $ten_student_history_id)
                                ->where('site_subject_group_condition_setting_id', $value['id'])
                                ->pluck('id');

                            $unchecked_sub_held_routine_list[]=SiteExamDeclareStudentSubject::where('site_exam_declare_id', $check_declared_list->id)
                                ->where('examination_id', $requests->examination_id)
                                ->whereIn('student_history_id', $ten_student_history_id)
                                ->where('site_subject_group_condition_setting_id', $value['id'])
                                ->pluck('site_exam_routine_id')
                                ->unique()
                                ->values();
                        }
                    }
                }
            }

            $unchecked_sub_held_routine_list_collaps=collect(array_merge($unchecked_sub_held_routine_list))->collapse()->toArray();
            $unchecked_sub_held_student_list_collaps=collect(array_merge($unchecked_sub_held_student_list))->collapse()->toArray();

            if($requests->first_time_update==1){

                $routine_ids=collect($routineIDs)->toArray();
                $routine_array_combine=collect(array_merge($unchecked_sub_held_routine_list_collaps, $routine_ids))
                    ->unique()
                    ->values()
                    ->toArray();

                $siteRoutineChecks=array_diff($declaredRoutineIds, $routine_array_combine);
                SiteExamRoutine::whereIn('id', $siteRoutineChecks)->update(['status' => false]);
            }

            $student_routine_ids=collect($studentRoutineIds)->toArray();

            $student_subject_array_combine=collect(array_merge($unchecked_sub_held_student_list_collaps, $student_routine_ids))
                ->unique()
                ->values()
                ->toArray();

            $siteStudentSubjectCheck=array_diff($declaredStudentRoutineIds->toArray(), $student_subject_array_combine);
            SiteExamDeclareStudentSubject::whereIn('id', $siteStudentSubjectCheck)->update(['status' => false]);;

            if(count($createds)>0){
                SiteExamDeclareStudentSubject::insert($createds);
            }

            DB::commit();

            if(count($studentRest)>0){
                return compact('studentRest', 'count_student',
                    'completed_student_id_array', 'completed_percent', 'siteExamDeclare_id');
            }else{
                return Response::json(['message' => 'information Update Successfully!', 'mode' => 'Update',
                    'completed_student_id_array' => $completed_student_id_array,
                    'count_student' => $count_student ], 200);
            }


       } catch (ValidationException $exception) {
           DB::rollBack();
           return JsonResponse::create(['message' => $exception->getMessage(), 'errors' => $exception->validator->getMessageBag()->toArray()], 422);
       } catch (Exception $exception) {
           DB::rollBack();
           return Response::json(['message' => $exception->getMessage()], 410);
       }


    }
}

